constant k_UsingThese_namerefs := nil;

if k_UsingThese_namerefs then
	begin

/************* LOCALIZE ******************************
	dataDefs:			// currently unused
		{
		invalidGroup:	"invalid group",
		newAddress:		"New Address",
		noAddresses:	"None",
		addInfoFor:		"^0 for ^1",
			// "Add email address for John Q. Public"
			// ^0 parameter is filled with add phrase
			// ^1 parameter is filled with full name
		addName:		"Add Name",
		},
************************************************/

// datadefs for QuickMail and cc:Mail addresses

DefConst ( 'kEnRouteAddressDataDef, {
	_proto:				protoPeopleDataDef,
	class:				nil,
	symbol:				nil,
	name:				"EnRoute Address",
	enRouteName:		"Data definitions",
	preferredRouting:	[ '|string.email| ],
	routePath:			'email,
	superSymbol:		'groupTransport,
	columns: [
		{
		fieldPath: 'name,
		optional: TRUE,
		tapWidth: 130,
		noPopup: TRUE,
		},

		{
		fieldPath: 'email,
	//	optional: TRUE,
		tapWidth: 0,
		},
	],

	QuerySpec: {
		type: 'index,
		indexPath: 'sorton,
		validTest: func ( e )
			begin
			local aClass;
			aClass := ClassOf(e);
			IsSubclass ( aClass, 'person )
			or IsSubclass ( aClass, 'company )
			or IsSubclass ( aClass, 'owner )
			or ( IsSubclass ( aClass, 'group )
			     and IsInstance ( e.members, '|nameRef.email| ) )
			//or aClass = 'frame;
			end,
		},

	MakeNameRef: func ( item, dataClass )
		begin
		// from page 6-23 of NPG-System
		local nameRef := inherited:MakeNameRef ( item, dataClass );
		local aEntry := EntryFromObj ( item );
		nameRef.email :=
			if IsInstance ( aEntry, 'group ) then
				aEntry.members;

			else if aEntry then
				begin
				local aMail := GetRoot().CardFile:bcEMailAddress ( aEntry, preferredRouting );

				if aMail and Length(aMail) > 0 then
					begin
					call k_SortByClassFunc with ( aMail, preferredRouting, 'email );
					local anotherMail := aMail[0];
					if IsFrame ( anotherMail ) then
						anotherMail.email;
					else
						anotherMail;
					end;
				end;

			// if the Obj already has an email slot, use it
			else if IsFrame(item) and item.email then
				item.email;

		nameRef;
		end,

 	GetSuffix: func ( object )
 		begin
 		return nil;

		/*************************************
		local Local1, Local2;
		data := :Get ( object, 'email, nil );
		if data then
			begin
			local temp := ClassOf ( data );
			temp := EmailSystems.emailText.(temp);
			if StrFilled(temp) then
				return ParamStr ( "(^0)", [temp] );
			end;
		return;
		***************************************/
		end,

	Get: func ( object, fieldPath, format )
		begin
		local data := inherited:Get ( object, fieldPath, format );

		if fieldPath = 'email then
			begin
			// for NameRefs
			if IsInstance ( object, symbol )
			and object.email
			and ClassOf(object.email) = preferredRouting[0] then
				begin
				return if object._entryClass = 'group then data else object.email;
				end;

			// for soup entries
			else if IsInstance ( object, 'group ) then
				begin
				// just for safety (should always evaluate to TRUE)
				return if IsInstance ( object.members, symbol ) then data
					else LocObj ( "invalid group", 'dataDefs.invalidGroup );
				end;

			local theMails := GetRoot().CardFile:bcEMailAddress ( EntryFromObj(object), preferredRouting );

			local aMSize;

			if theMails and (aMSize := Length ( theMails )) > 0 then
				begin
				call k_SortByClassFunc with ( theMails, preferredRouting, 'email );
				end;

			data := if theMails and Length(theMails) > 0 then
				theMails[0].email;
			else if format = 'text then
				"--";
			else
				nil;
			end;

		data;
		end,


	MakePopup: func ( object, fieldPath )
		begin
		local thePop;

		if fieldPath <> 'email then
			begin
			return;
			end;

		// for group soup entries
		if IsInstance ( object, 'group ) and IsInstance ( object.members, symbol ) then
			begin
			return;
			end;

		// for group NameRefs
		if object._entryClass = 'group then
			begin
			return nil;
			end;

		local theMails := GetRoot().CardFile:bcEMailAddress ( EntryFromObj(object), preferredRouting );

		local aMSize;

		if theMails and (aMSize := Length ( theMails )) > 0 then
			begin
			call k_SortByClassFunc with ( theMails, preferredRouting, 'email );
			thePop := Array ( aMSize + 2, nil );
			local i;
			for i := 0 to aMSize - 1 do
				begin
				local aMail := theMails[i].email;
				//local aText := ParamStr ( "^0 (^1)", [aMail, EmailSystems.emailText.(ClassOf(aMail))]);
				local aText := aMail;
				thePop[i] := {
					value:    aMail,
					item:     aText,
					pickable: true,
				};
				end;

			thePop[aMSize] := 'pickseparator;

			thePop [ aMSize + 1 ] := {
				item:     LocObj ( "New Address", 'dataDefs.newAddress ),
				value:    'OpenEditor,
				pickable: true,
			};
			end;
		thePop;
		end,


	GetRoutingTitle: func ( Arg1, Arg2, Arg3 )
		begin
		local Local1, Local2, Local4;
		if Arg1 and IsArray(Arg1) = nil then
			Local1 := :Get ( Arg1, primaryPath, 'text );
		else
			begin
			if Arg1 and Length(Arg1) > 0 then
				begin
				foreach Local2 in Arg1 do
					begin
					Local4 := :Get ( Local2, primaryPath, 'text );
					if Local1 and StrFilled(Local1) then
						Local1 := ParamStr ( "^0, ^1", [Local1, Local4] );
					else
						Local1 := Local4;
					if Arg3 and Arg2 then
						if StrFontWidth ( Local1, Arg3 ) > Arg2 then break;
					end;
	
				if Local1 and StrFilled ( Local1 ) and Arg3 and Arg2 then
					Local1 := StyledStrTruncate( clone(Local1), Arg2, Arg3 );
				end;
			else
				Local1 := LocObj ( "None", 'dataDefs.noAddresses );
			end;

		Local1;
		end,



	GetItemRoutingFrame: func ( object )
		begin
		{
		name:  :Get ( object, 'name, 'text ),
		email: :Get ( object, 'email, nil ),	//'text ),	// 
		};
		end,


	DefaultEditDone: func ( modified )
		begin
		if modified then
			begin
			inherited:DefaultEditDone ( modified );
			end;
		else
			begin
			_context:Tapped ( nil );
			_tapinfo := nil;
			_dirtyPaths := nil;
			_dirtyValues := nil
			end;
		end,


	DefaultOpenEditor: func ( tapInfo, context, why )
		begin
		local object, data;
		object := tapInfo.nameRef;
		data := :Get ( object, primaryPath, 'text );
		if data and not IsInstance ( data, '|string.noData| ) then
			editTitle := ParamStr (
				LocObj ( "^0 for ^1", 'dataDefs.addInfoFor ),
				[ enRouteEditTitle, data ] );

		else if tapInfo.fieldPath = 'name then
			editTitle := LocObj ( "Add Name", 'dataDefs.addName );

		else if tapInfo.fieldPath = 'email then
			editTitle := enRouteAddTitle;	//"Add" && enRouteName && "address";
		else
			editTitle := defaultEditTitle;

		inherited:DefaultOpenEditor ( tapInfo, context, why );
		end,


	ModifyEntry: func ( object, fieldPaths )
		begin
		local anEntry := EntryFromObj ( object );

		if anEntry then
			begin
			local cf := GetRoot().CardFile;
			local path;
			foreach path in fieldPaths do
				begin
				if path = 'email then
					cf:AddCardData ( anEntry, 'email, { email: object.email, } );
				else
					:ModifyEntryPath ( object, anEntry, path );
				end;

			EntryChangeXmit ( anEntry, 'entryChanged );		// undocumented EntryChangeXmit???
			end;
		end,


	NewEntry: func ( nameRef, unused )
		begin
		local cf := GetRoot().CardFile;
		local aMail := nameRef.email;
		RemoveSlot ( nameRef, 'email );
		local anEntry := :PrepareToAdd ( nameRef );
		anEntry := cf:AddCard ( anEntry.class, anEntry );
		cf:AddCardData ( anEntry, 'email, { email: aMail, } );
		EntryChangeXmit ( anEntry, 'entryAdded );
		:FixupPostAdd ( nameRef, anEntry );
		nameRef.email := aMail;
		anEntry;
		end,
} );


// =================================================================

constant kQMNameRefSymbol:= '|nameRef.email.quickMail|;

DefConst ( 'kQMAddressDataDef, {
	_proto:				kEnRouteAddressDataDef,
	class:				kQMNameRefSymbol,
	symbol:				kQMNameRefSymbol,
	name:				"QuickMail Users",
	enRouteName:		"QuickMail",
	enRouteEditTitle:	"New QuickMail ID",
	enRouteAddTitle:	"Add QuickMail ID",
	preferredRouting:	[ '|string.email.quickMail| ],

	QuerySpec: {
		type: 'index,
		indexPath: 'sorton,
		validTest: func ( e )
			begin
			local aClass;
			aClass := ClassOf(e);
			IsSubclass ( aClass, 'person )
			or IsSubclass ( aClass, 'company )
			or IsSubclass ( aClass, 'owner )
			or ( IsSubclass ( aClass, 'group )
			     and IsInstance ( e.members, '|nameRef.email.quickMail| ) )
			or aClass = 'frame;
			end,
		},
	} );


constant kccMailNameRefSymbol:= '|nameRef.email.cc:Mail|;

DefConst ( 'kccMailAddressDataDef, {
	_proto:				kEnRouteAddressDataDef,
	class:				kccMailNameRefSymbol,
	symbol:				kccMailNameRefSymbol,
	name:				"cc:Mail Users",
	enRouteName:		"cc:Mail",
	enRouteEditTitle:	"New cc:Mail ID",
	enRouteAddTitle:	"Add cc:Mail ID",
	preferredRouting:	[ '|string.email.cc:Mail| ],

	QuerySpec: {
		type: 'index,
		indexPath: 'sorton,
		validTest: func ( e )
			begin
			local aClass;
			aClass := ClassOf(e);
			IsSubclass ( aClass, 'person )
			or IsSubclass ( aClass, 'company )
			or IsSubclass ( aClass, 'owner )
			or ( IsSubclass ( aClass, 'group )
			     and IsInstance ( e.members, '|nameRef.email.cc:Mail| ) )
			or aClass = 'frame;
			end,
		},
	} );


constant k121MailNameRefSymbol:= '|nameRef.email.121Mail|;

DefConst ( 'k121MailAddressDataDef, {
	_proto:				kEnRouteAddressDataDef,
	class:				k121MailNameRefSymbol,
	symbol:				k121MailNameRefSymbol,
	name:				"One 2 One Users",
	enRouteName:		"One 2 One",
	enRouteEditTitle:	"New One 2 One ID",
	enRouteAddTitle:	"Add One 2 One ID",
	preferredRouting:	[ '|string.email.121Mail| ],

//	singleSelect:		true,

	QuerySpec: {
		type: 'index,
		indexPath: 'sorton,
		validTest: func ( e )
			begin
			local aClass;
			aClass := ClassOf(e);
			IsSubclass ( aClass, 'person )
			or IsSubclass ( aClass, 'company )
			or IsSubclass ( aClass, 'owner )
			or ( IsSubclass ( aClass, 'group )
			     and IsInstance ( e.members, '|nameRef.email.121Mail| ) )
			or aClass = 'frame;
			end,
		},
	} );


constant kInternetNameRefSymbol:= '|nameRef.email.internet|;

DefConst ( 'kInternetAddressDataDef, {
	_proto:				kEnRouteAddressDataDef,
	class:				kInternetNameRefSymbol,
	symbol:				kInternetNameRefSymbol,
	name:				"Internet IDs",
	enRouteName:		"EnRoute Net_One",
	enRouteEditTitle:	"New address",
	enRouteAddTitle:	"Add Internet address",
	preferredRouting:	[ '|string.email.internet| ],
	} );

	end;	//	k_UsingThese_namerefs